<?php

/*
 * Senternal Hosting Control Panel
 * (c) Senternal LLC <http://www.senternal.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\DBAL\Types\Types;
use Symfony\Component\Validator\Constraints as Assert;

use App\Repository\MailboxRepository;

#[ORM\Entity(repositoryClass: MailboxRepository::class)]
#[ORM\Table(name: "mailbox")]
class Mailbox
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column(type: Types::INTEGER)]
    private ?int $id = null;

    #[ORM\Column(type: Types::STRING, unique: true)]
    #[Assert\NotBlank]
    #[Assert\Length(min: 2, max: 50)]
    private ?string $username;

    #[ORM\Column(type: Types::STRING)]
    private ?string $password = null;

    #[ORM\Column(type: "string", length: 255)]
    private string $name;

    #[ORM\ManyToOne]
    #[ORM\JoinColumn(nullable: false)]
    private ?User $owner = null;

    #[ORM\Column(type: "string", length: 255)]
    private string $maildir;

    #[ORM\Column(type: "boolean")]
    private bool $active;

    #[ORM\Column(type: Types::DATETIME_IMMUTABLE, options: ["default" => 0])]
    #[Assert\NotBlank]
    private \DateTime $created;

    #[ORM\Column(type: Types::DATETIME_IMMUTABLE, options: ["default" => 0])]
    #[Assert\NotBlank]
    private \DateTime $modified;

    #[ORM\Column(type: Types::DATETIME_IMMUTABLE, options: ["default" => 0])]
    #[Assert\NotBlank]
    private ?\DateTime $expired;

    public function getUsername(): string
    {
        return $this->username;
    }

    public function setUsername(string $username): self
    {
        $this->username = $username;
        return $this;
    }

    public function getPassword(): string
    {
        return $this->password;
    }

    public function setPassword(string $password): self
    {
        $this->password = $password;
        return $this;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;
        return $this;
    }

    public function getMaildir(): string
    {
        return $this->maildir;
    }

    public function setMaildir(string $maildir): self
    {
        $this->maildir = $maildir;
        return $this;
    }

    public function isActive(): bool
    {
        return $this->active;
    }

    public function setActive(bool $active): self
    {
        $this->active = $active;
        return $this;
    }

    public function getCreated(): \DateTime
    {
        return $this->created;
    }

    public function setCreated(\DateTime $created): self
    {
        $this->created = $created;
        return $this;
    }

    public function getModified(): \DateTime
    {
        return $this->modified;
    }

    public function setModified(\DateTime $modified): self
    {
        $this->modified = $modified;
        return $this;
    }

    public function getExpired(): ?\DateTime
    {
        return $this->expired;
    }

    public function setExpired(?\DateTime $expired): self
    {
        $this->expired = $expired;
        return $this;
    }
}