<?php

/*
 * Senternal Hosting Control Panel
 * (c) Senternal LLC <http://www.senternal.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\DBAL\Types\Types;

use Doctrine\ORM\LastLoginRepository;

#[ORM\Entity(repositoryClass: LastLoginRepository::class)]
#[ORM\Table(name: "last_login")]
class LastLogin
{
    #[ORM\Id]
    #[ORM\Column(type: "string", length: 255)]
    private string $username;

    #[ORM\Column(type: Types::DATETIME_IMMUTABLE, options: ["default" => 0])]
    private \DateTime $loginTime;

    #[ORM\Column(type: "string", length: 255)]
    private string $ipAddress;

    public function getUsername(): string
    {
        return $this->username;
    }

    public function setUsername(string $username): self
    {
        $this->username = $username;
        return $this;
    }

    public function getLoginTime(): \DateTime
    {
        return $this->loginTime;
    }

    public function setLoginTime(\DateTime $loginTime): self
    {
        $this->loginTime = $loginTime;
        return $this;
    }

    public function getIpAddress(): string
    {
        return $this->ipAddress;
    }

    public function setIpAddress(string $ipAddress): self
    {
        $this->ipAddress = $ipAddress;
        return $this;
    }
}