# Bootstrap SCSS

> Bootstrap's SCSS files (only)

<p align="center">
  <a href="https://getbootstrap.com/">
    <img src="https://getbootstrap.com/docs/5.3/assets/brand/bootstrap-logo-shadow.png" alt="Bootstrap logo" width="200" height="165">
  </a>
</p>

<h3 align="center">Bootstrap</h3>

<p align="center">
  Sleek, intuitive, and powerful front-end framework for faster and easier web development.
  <br>
  <a href="https://getbootstrap.com/docs/5.3/"><strong>Explore Bootstrap docs »</strong></a>
  <br>
  <br>
  <a href="https://github.com/twbs/bootstrap/issues/new?template=bug_report.md">Report bug</a>
  ·
  <a href="https://github.com/twbs/bootstrap/issues/new?template=feature_request.md">Request feature</a>
  ·
  <a href="https://themes.getbootstrap.com/">Themes</a>
  ·
  <a href="https://blog.getbootstrap.com/">Blog</a>
</p>

<br>

## Table of contents

- [Quick start](#quick-start)
- [Status](#status)
- [What's included](#whats-included)
- [Documentation](#documentation)
- [Versioning](#versioning)
- [Copyright and license](#copyright-and-license)

## Quick start

Several quick start options are available:

- Install with [npm](https://www.npmjs.com/): `npm install bootstrap-scss`
- Install with [yarn](https://yarnpkg.com/): `yarn add bootstrap-scss`

Read the [Getting started page](https://getbootstrap.com/docs/5.3/getting-started/introduction/) for information on the framework contents, templates and examples, and more.

## Status

[![npm version](https://img.shields.io/npm/v/bootstrap-scss.svg)](https://www.npmjs.com/package/bootstrap-scss)

## What's included

Within this package you'll find the following directories and files, logically grouping common assets and providing only SCSS variations. You'll see something like this:

```
bootstrap-scss/
├── bootstrap.scss
├── bootstrap-grid.scss
├── bootstrap-reboot.scss
├── bootstrap-utilities.css
├── mixins/
│   └─ ...
└── utilities/
    └─ ...
└── vendor/
    └─ ...
```

## Documentation

[Bootstrap's official documentation](https://getbootstrap.com/) powered by [Algolia's DocSearch](https://community.algolia.com/docsearch/).

## Versioning

For simplicity, this project will use the same version numbers as Bootstrap.

## Changelog

https://github.com/twbs/bootstrap/releases/tag/v5.3.3

## Copyright and license

Code and documentation copyright 2011-2022 the [Bootstrap Authors](https://github.com/twbs/bootstrap/graphs/contributors) and [Twitter, Inc.](https://twitter.com) Code released under the [MIT License](https://github.com/twbs/bootstrap/blob/main/LICENSE).
